#!/bin/bash

fdisk -l /dev/sd? | 						
  grep GB, | 							# Disk /dev/sda: 2000.4 GB, 2000398934016 bytes
  cut -d , -f1 | 						# Disk /dev/sda: 2000.4 GB
  tr ":/" " " | 						# Disk  dev sda  2000.4 GB
  while read DISK DEV sd sizegb gb; do 
    echo $sd":	${sizegb}G "`smartctl -i /dev/$sd | awk '/(Model|Serial)/ {print $3" "$4" "}'`
    grep $sd /proc/mdstat | 					# md0 : active raid1 sdd1[0] sda1[2] sde1[1]
    tr "[]" " " | grep raid |					# md0 : active raid1 sdd1 0  sda1 2  sde1 1
    while read md COLON ACTIVE raid disks; do                   #  md col active raid disks------------------>
      sdpart=`echo $disks | tr " " "\n" | grep $sd`
      sdpsize="`grep $sdpart /proc/partitions | awk '{printf \"%10.1G\",int($3/1024/1024*10)/10}'`"
      mnt=`grep /dev/$md /proc/mounts | cut -d " " -f2`
      a="`df -B G /dev/$md | grep -v Filesystem`"
      echo $a |
        while read dev2 total used avail use mnt2; do
          echo "  $sdpart	$md	$raid	$sdsize	$total	$used	$avail	$use	$mnt"
        done
    done
    echo
  done

#  while read sd size gb part md; do 
#    echo $size GB $part "`grep $part /proc/partitions | awk '{printf \"%10.1f GB\",int($3/1024/1024*10)/10}'`" $md `grep $md /proc/mounts | 
#    cut -d " " -f2`; 
#  done |
#  sort -k1 -k3
#Filesystem           1G-blocks      Used Available Use% Mounted on
#rootfs                      8G        2G        7G  17% /
#/dev/md5                 1835G     1238G      598G  68% /backups::

#sde: 2000.4 GB   SAMSUNG HD204UI S2HFJ1AZB01951
#      sde2  md2  /bv3-backups   (1708G of 1835G 94% used, 128G avail)
#      sde1  md0         (1G of 2G 1% used, 2G avail)
#
