#!/bin/bash

export PEER=""
export ROUTE=""
export LISTPEERS=""
export LISTROUTES=""

usage () {
  echo "USAGE: $0 [OPTIONS]"
  echo " -p             given a [p]eer, list the number of routes advertised"
  echo " -r             given a [r]oute, list the peer"
  echo " -e             list total number of p[e]ers"
  echo " -o             list total number of r[o]utes"
}

while getopts p:r:eo option; do
    case $option in
        p)  PEER=$OPTARG
        ;;
        r)  ROUTE=$OPTARG
        ;;
        e)  LISTPEERS=yes
        ;;
        o)  LISTROUTES=yes
        ;;
        [?])
            usage
            exit
        ;;
  esac
done

if [ -n "${PEER}" ]
then
  netstat -rn | grep -c ${PEER}
fi

if [ -n "${ROUTE}" ]
then
  netstat -rn | grep ${ROUTE} | awk '{print $2}'
fi

if [ -n "${LISTPEERS}" ]
then
  netstat -rn | awk '{print $2}' | sort | uniq -c | wc -l
fi

if [ -n "${LISTROUTES}" ]
then
  netstat -rn | wc -l
fi


