#!/bin/sh

./deleteOldVersion.sh
retval=$?
if [ $retval == 1 ]; then
  exit
fi

if [ -f /usr/lib/libstdc++.so.6 ]; then
      libstdc=1;
      else
      libstdc=0;
      echo "File /usr/lib/libstdc++.so.6 not found"
      echo "Install the libstdc++ rpm from the OS CD and retry"
      echo "Refer to MSM readme for more details"
      exit 0;
fi

##Check for Third-party library RPM
utils2_rpm=`rpm -qa | grep Lib_Utils2-1 | wc -l`
if [ $utils2_rpm = 0 ]; then
        rpm -ivh Lib_Utils2-1.00-02.noarch.rpm
else
        newdate=1320986530
		olddate=`rpm -q --queryformat "%{BUILDTIME}" Lib_Utils2`
		if [ $newdate -gt $olddate ]; then
			rpm -ivh Lib_Utils2-1.00-02.noarch.rpm --force
		fi
		if [ $newdate -eq $olddate ]; then
			echo "Latest Lib_Utils2 RPM is already installed"
		fi
fi

##Step 2 : Install MegaRAID Storage Manager 13.01.04-00

rpm -i --test MegaRAID_Storage_Manager-13.01.04-00.noarch.rpm
status=$?
if [ $status = 0 ]; then
  echo "Installing  MegaRAID_Storage_Manager-13.01.04-00"
  rpm -ivh MegaRAID_Storage_Manager-13.01.04-00.noarch.rpm
else
  echo "RPM Installation Failed"
  exit 1
fi


if [ "$setuptype" = "" ]; then
	setuptype="a"
fi
if [ "$removesnmp" = "" ]; then
	removesnmp=0
fi
#Step 3: Install SAS SNMP
step3status=0
if [ "$setuptype" != "c" ]; then
  if [ $removesnmp = 0 ]; then
	rpm -i --test sas_snmp-13.01-0300.i386.rpm
	status=$?
	if [ $status = 0 ]; then
		echo "Installing sas_snmp-13.01-0300"
		rpm -ivh sas_snmp-13.01-0300.i386.rpm
	else
		step3status=1
		echo "SAS SNMP installation failed"
	fi
  else
	step3status=1
  fi
else
  step3status=1
fi

##Step 4: Install SAS-IR SNMP
step4status=0
if [ "$setuptype" != "c" ]; then
  if [ $removesnmp = 0 ]; then
	rpm -i --test sas_ir_snmp-13.01-0300.i386.rpm
	status=$?
	if [ $status = 0 ]; then
		echo "Installing sas_ir_snmp-13.01-0300"
		rpm -ivh sas_ir_snmp-13.01-0300.i386.rpm
	else
		step4status=1
		echo "SAS-IR SNMP installation failed"
	fi
  else
	step4status=1
  fi
else
  step4status=1
fi


uninst="/usr/local/MegaRAID Storage Manager/.__uninst.sh"
if [ $step4status = 0 ]; then
	echo "echo \"Uninstalling sas_ir_snmp-13.01-0300\"" >> $uninst
	echo "rpm -e sas_ir_snmp-13.01-0300" >> $uninst
fi
if [ $step3status = 0 ]; then
	echo "echo \"Uninstalling sas_snmp-13.01-0300\"" >> $uninst
	echo "rpm -e sas_snmp-13.01-0300" >> $uninst
fi
echo "echo \"Uninstalling MegaRAID_Storage_Manager-13.01.04-00\" " >> $uninst
echo "rpm -e MegaRAID_Storage_Manager-13.01.04-00" >> $uninst
echo "status=\$?" >>$uninst
echo "if [ \$status -ne 0 ]; then" >> $uninst
echo "     exit 1" >> $uninst
echo "fi" >> $uninst
echo "echo \"Uninstalling Lib_Utils2-1.00-02\" " >> $uninst
echo "rpm -e Lib_Utils2-1.00-02" >> $uninst
echo "status=\$?" >>$uninst
echo "if [ \$status -ne 0 ]; then" >> $uninst
echo "     exit 1" >> $uninst
echo "fi" >> $uninst
echo "echo \"Done.\" " >>$uninst
chmod +x "$uninst"
